﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using System.Collections.Generic;
using GE.World.Entities;
using Microsoft.Xna.Framework;

namespace GE.Manager
{
    class BulletManager
    {
        /// <summary>
        /// Singleton instance
        /// </summary>
        static BulletManager _instance = null;

        /// <summary>
        /// Number of bullet the manager handles
        /// </summary>
        int _iBulletCount;

        /// <summary>
        /// List of reference to the bullet entities
        /// </summary>
        List<BulletEntity> _listBulletEntity;

        /// <summary>
        /// Constructor
        /// </summary>
        private BulletManager()
        {
            _iBulletCount = 0;
            _listBulletEntity = new List<BulletEntity>();
        }

        /// <summary>
        /// Return the singleton
        /// </summary>
        static public BulletManager Instance
        {
            get
            {
                if (_instance == null)
                    _instance = new BulletManager();

                return _instance;
            }
        }

        /// <summary>
        /// Initialise the bullet manager
        /// </summary>
        /// <param name="bulletCount">Number of bullet to handle</param>
        /// <returns>Return true.</returns>
        public bool init(int bulletCount)
        {
            //create the blank bullet and store references
            _iBulletCount = bulletCount;
            for (int i = 0; i < _iBulletCount; i++)
            {
                _listBulletEntity.Add(World.World.Instance.createBlankBullet());
            }
            return true;
        }

        public void clear()
        {
            _listBulletEntity.Clear();
        }

        /// <summary>
        /// Activate a bullet
        /// </summary>
        /// <param name="idTexture"></param>
        /// <param name="idSprite"></param>
        /// <param name="lifeTime"></param>
        /// <param name="damages"></param>
        /// <param name="speed"></param>
        /// <param name="position"></param>
        /// <returns>Return true if a bullet was activated or false if the manager couldn't activate a bullet.</returns>
        public bool activate(int idTexture, int idSprite, int lifeTime, int damages, Vector2 speed, Vector2 position, eSide side)
        {
            for (int i = 0; i < _listBulletEntity.Count; i++)
            {
                if (!_listBulletEntity[i].Active)
                {
                    _listBulletEntity[i].activate(idTexture, idSprite, lifeTime, damages, speed, position, side);
                    return true;
                }
            }

            return false;
        }
    }
}
